//Break Even Point
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Given
fixed_cost = 500       //in rupees
variable_cost = 100    //in rupees per unit
selling_price = 200    //in rupees per unit
units = []
total_variable_cost = []
total_cost = []
total_revenue = []

//Solution
for i = 0:10
    units($+1) = i
    total_variable_cost($+1) = i * variable_cost
    total_cost($+1) = total_variable_cost(i+1) + fixed_cost
    total_revenue($+1) = units(i+1) * selling_price
end

for i = 1:10
    if total_cost(i) == total_revenue(i) then
        BEP_units = i
    else
        i = i + 1
    end
end

//Result
mprintf("\n Units  FC(in Rs)  VC(per unit)  TVC     TC  SP(per unit)  TR")
for i = 0:10
    mprintf("\n   %d\t  %d\t     %d\t %d\t %d\t%d\t   %d",units(i+1),fixed_cost,variable_cost,total_variable_cost(i+1),total_cost(i+1),selling_price,total_revenue(i+1))
end

mprintf("\nBreak Even Point occurs at %d units",BEP_units-1)

//Output
// 
// Units  FC(in Rs)  VC(per unit)  TVC     TC  SP(per unit)  TR
//   0	  500	     100	 0	 500	200	   0
//   1	  500	     100	 100	 600	200	   200
//   2	  500	     100	 200	 700	200	   400
//   3	  500	     100	 300	 800	200	   600
//   4	  500	     100	 400	 900	200	   800
//   5	  500	     100	 500	 1000	200	   1000
//   6	  500	     100	 600	 1100	200	   1200
//   7	  500	     100	 700	 1200	200	   1400
//   8	  500	     100	 800	 1300	200	   1600
//   9	  500	     100	 900	 1400	200	   1800
//   10	  500	     100	 1000	 1500	200	   2000
//Break Even Point occurs at 5 units
